// Listing 6-8

import java.util.Scanner;

public class Listing6_8
{
   public static void main(String[] args)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);

      // Zmienne lokalne
      double sales, commissionRate, advancedPay, pay;
      
      // Pobieramy wartość sprzedaży
      sales = getSales();
      
      // Pobieramy wartość pobranej zaliczki
      advancedPay = getAdvancedPay();
      
      // Określamy wysokość premii
      commissionRate = determineCommissionRate(sales);
      
      // Obliczamy wynagrodzenie
      pay = sales * commissionRate - advancedPay;
      
      // Wyświetlamy wynagrodzenie
      System.out.println("Wynagrodzenie wynosi " + pay + " zł.");
      
      // Sprawdzamy, czy wynagrodzenie jest ujemne
      if (pay < 0)
      {
         System.out.println("Pracownik musi zwrócić");
         System.out.println("pieniądze firmie.");
      }
   }
   
   // Funkcja getSales pobiera od użytkownika
   // wartość miesięcznej sprzedaży i zwraca
   // tę wartość jako liczbę typu double
   public static double getSales()
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Zmienna lokalna, w której zapiszemy wartość sprzedaży
      double sales;
      
      // Pobieramy wartość sprzedaży
      System.out.print("Wprowadź wartość miesięcznej sprzedaży pracownika.");
      sales = keyboard.nextDouble();
      
      // Zwracamy wartość miesięcznej sprzedaży
      return sales;
   }
   
   // Funkcja getAdvancedPay pobiera wartość zaliczki
   // wypłaconej danemu pracownikowi
   // i zwraca ją jako liczbę typu double
   public static double getAdvancedPay()
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Zmienna lokalna, w której zapiszemy wartość zaliczki
      double advanced;
      
      // Pobieramy wartość wypłaconej zaliczki
      System.out.println("Wprowadź wartość wypłaconej zaliczki lub");
      System.out.print("0, jeżeli zaliczka nie została wypłacona.");
      advanced = keyboard.nextDouble();
      
      // Zwracamy wartość zaliczki
      return advanced;
   }

   // Funkcja determineCommissionRate przyjmuje jako argument
   // wartość sprzedaży i zwraca
   // wysokość premii jako liczbę typu double
   public static double determineCommissionRate(double sales)
   {
      // Zmienna lokalna, w której zapiszemy wysokość premii
      double rate;
      
      // Określamy wysokość premii
      if (sales < 10000)
         rate = 0.10;
      else if (sales >= 10000 && sales <= 14999)
         rate = 0.12;
      else if (sales >= 15000 && sales <= 17999)
         rate = 0.14;
      else if (sales >= 18000 && sales <= 21999)
         rate = 0.16;
      else
         rate = 0.18;
   
      // Zwracamy wysokość premii
      return rate;
   }
}